<?php

namespace Modules\Language\app\Enums;

use Illuminate\Support\Collection;

enum AllCountriesDetailsEnum: string
{
    public static function getAll(): Collection
    {
        return collect((object) [
            (object) ['name' => 'Afghanistan', 'code' => 'AF', 'id' => 1, 'phone' => 93, 'symbol' => '؋', 'capital' => 'Kabul', 'currency' => 'AFN', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'AFG'],
            (object) ['name' => 'Aland Islands', 'code' => 'AX', 'id' => 2, 'phone' => 358, 'symbol' => '€', 'capital' => 'Mariehamn', 'currency' => 'EUR', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'ALA'],
            (object) ['name' => 'Albania', 'code' => 'AL', 'id' => 3, 'phone' => 355, 'symbol' => 'Lek', 'capital' => 'Tirana', 'currency' => 'ALL', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'ALB'],
            (object) ['name' => 'Algeria', 'code' => 'DZ', 'id' => 4, 'phone' => 213, 'symbol' => 'دج', 'capital' => 'Algiers', 'currency' => 'DZD', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'DZA'],
            (object) ['name' => 'American Samoa', 'code' => 'AS', 'id' => 5, 'phone' => 1684, 'symbol' => '$', 'capital' => 'Pago Pago', 'currency' => 'USD', 'continent' => 'Oceania', 'continent_code' => 'OC', 'alpha_3' => 'ASM'],
            (object) ['name' => 'Andorra', 'code' => 'AD', 'id' => 6, 'phone' => 376, 'symbol' => '€', 'capital' => 'Andorra la Vella', 'currency' => 'EUR', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'AND'],
            (object) ['name' => 'Angola', 'code' => 'AO', 'id' => 7, 'phone' => 244, 'symbol' => 'Kz', 'capital' => 'Luanda', 'currency' => 'AOA', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'AGO'],
            (object) ['name' => 'Anguilla', 'code' => 'AI', 'id' => 8, 'phone' => 1264, 'symbol' => '$', 'capital' => 'The Valley', 'currency' => 'XCD', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'AIA'],
            (object) ['name' => 'Antarctica', 'code' => 'AQ', 'id' => 9, 'phone' => 672, 'symbol' => '$', 'capital' => 'Antarctica', 'currency' => 'AAD', 'continent' => 'Antarctica', 'continent_code' => 'AN', 'alpha_3' => 'ATA'],
            (object) ['name' => 'Antigua and Barbuda', 'code' => 'AG', 'id' => 10, 'phone' => 1268, 'symbol' => '$', 'capital' => "St. John's", 'currency' => 'XCD', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'ATG'],
            (object) ['name' => 'Argentina', 'code' => 'AR', 'id' => 11, 'phone' => 54, 'symbol' => '$', 'capital' => 'Buenos Aires', 'currency' => 'ARS', 'continent' => 'South America', 'continent_code' => 'SA', 'alpha_3' => 'ARG'],
            (object) ['name' => 'Armenia', 'code' => 'AM', 'id' => 12, 'phone' => 374, 'symbol' => '֏', 'capital' => 'Yerevan', 'currency' => 'AMD', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'ARM'],
            (object) ['name' => 'Aruba', 'code' => 'AW', 'id' => 13, 'phone' => 297, 'symbol' => 'ƒ', 'capital' => 'Oranjestad', 'currency' => 'AWG', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'ABW'],
            (object) ['name' => 'Australia', 'code' => 'AU', 'id' => 14, 'phone' => 61, 'symbol' => '$', 'capital' => 'Canberra', 'currency' => 'AUD', 'continent' => 'Oceania', 'continent_code' => 'OC', 'alpha_3' => 'AUS'],
            (object) ['name' => 'Austria', 'code' => 'AT', 'id' => 15, 'phone' => 43, 'symbol' => '€', 'capital' => 'Vienna', 'currency' => 'EUR', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'AUT'],
            (object) ['name' => 'Azerbaijan', 'code' => 'AZ', 'id' => 16, 'phone' => 994, 'symbol' => 'm', 'capital' => 'Baku', 'currency' => 'AZN', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'AZE'],
            (object) ['name' => 'Bahamas', 'code' => 'BS', 'id' => 17, 'phone' => 1242, 'symbol' => 'B$', 'capital' => 'Nassau', 'currency' => 'BSD', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'BHS'],
            (object) ['name' => 'Bahrain', 'code' => 'BH', 'id' => 18, 'phone' => 973, 'symbol' => '.د.ب', 'capital' => 'Manama', 'currency' => 'BHD', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'BHR'],
            (object) ['name' => 'Bangladesh', 'code' => 'BD', 'id' => 19, 'phone' => 880, 'symbol' => '৳', 'capital' => 'Dhaka', 'currency' => 'BDT', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'BGD'],
            (object) ['name' => 'Barbados', 'code' => 'BB', 'id' => 20, 'phone' => 1246, 'symbol' => 'Bds$', 'capital' => 'Bridgetown', 'currency' => 'BBD', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'BRB'],
            (object) ['name' => 'Belarus', 'code' => 'BY', 'id' => 21, 'phone' => 375, 'symbol' => 'Br', 'capital' => 'Minsk', 'currency' => 'BYN', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'BLR'],
            (object) ['name' => 'Belgium', 'code' => 'BE', 'id' => 22, 'phone' => 32, 'symbol' => '€', 'capital' => 'Brussels', 'currency' => 'EUR', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'BEL'],
            (object) ['name' => 'Belize', 'code' => 'BZ', 'id' => 23, 'phone' => 501, 'symbol' => '$', 'capital' => 'Belmopan', 'currency' => 'BZD', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'BLZ'],
            (object) ['name' => 'Benin', 'code' => 'BJ', 'id' => 24, 'phone' => 229, 'symbol' => 'CFA', 'capital' => 'Porto-Novo', 'currency' => 'XOF', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'BEN'],
            (object) ['name' => 'Bermuda', 'code' => 'BM', 'id' => 25, 'phone' => 1441, 'symbol' => '$', 'capital' => 'Hamilton', 'currency' => 'BMD', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'BMU'],
            (object) ['name' => 'Bhutan', 'code' => 'BT', 'id' => 26, 'phone' => 975, 'symbol' => 'Nu.', 'capital' => 'Thimphu', 'currency' => 'BTN', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'BTN'],
            (object) ['name' => 'Bolivia', 'code' => 'BO', 'id' => 27, 'phone' => 591, 'symbol' => 'Bs.', 'capital' => 'Sucre', 'currency' => 'BOB', 'continent' => 'South America', 'continent_code' => 'SA', 'alpha_3' => 'BOL'],
            (object) ['name' => 'Bonaire, Sint Eustatius and Saba', 'code' => 'BQ', 'id' => 28, 'phone' => 599, 'symbol' => '$', 'capital' => 'Kralendijk', 'currency' => 'USD', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'BES'],
            (object) ['name' => 'Bosnia and Herzegovina', 'code' => 'BA', 'id' => 29, 'phone' => 387, 'symbol' => 'KM', 'capital' => 'Sarajevo', 'currency' => 'BAM', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'BIH'],
            (object) ['name' => 'Botswana', 'code' => 'BW', 'id' => 30, 'phone' => 267, 'symbol' => 'P', 'capital' => 'Gaborone', 'currency' => 'BWP', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'BWA'],
            (object) ['name' => 'Bouvet Island', 'code' => 'BV', 'id' => 31, 'phone' => 55, 'symbol' => 'kr', 'capital' => '', 'currency' => 'NOK', 'continent' => 'Antarctica', 'continent_code' => 'AN', 'alpha_3' => 'BVT'],
            (object) ['name' => 'Brazil', 'code' => 'BR', 'id' => 32, 'phone' => 55, 'symbol' => 'R$', 'capital' => 'Brasilia', 'currency' => 'BRL', 'continent' => 'South America', 'continent_code' => 'SA', 'alpha_3' => 'BRA'],
            (object) ['name' => 'British Indian Ocean Territory', 'code' => 'IO', 'id' => 33, 'phone' => 246, 'symbol' => '$', 'capital' => 'Diego Garcia', 'currency' => 'USD', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'IOT'],
            (object) ['name' => 'Brunei Darussalam', 'code' => 'BN', 'id' => 34, 'phone' => 673, 'symbol' => 'B$', 'capital' => 'Bandar Seri Begawan', 'currency' => 'BND', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'BRN'],
            (object) ['name' => 'Bulgaria', 'code' => 'BG', 'id' => 35, 'phone' => 359, 'symbol' => 'Лв.', 'capital' => 'Sofia', 'currency' => 'BGN', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'BGR'],
            (object) ['name' => 'Burkina Faso', 'code' => 'BF', 'id' => 36, 'phone' => 226, 'symbol' => 'CFA', 'capital' => 'Ouagadougou', 'currency' => 'XOF', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'BFA'],
            (object) ['name' => 'Burundi', 'code' => 'BI', 'id' => 37, 'phone' => 257, 'symbol' => 'FBu', 'capital' => 'Bujumbura', 'currency' => 'BIF', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'BDI'],
            (object) ['name' => 'Cambodia', 'code' => 'KH', 'id' => 38, 'phone' => 855, 'symbol' => 'KHR', 'capital' => 'Phnom Penh', 'currency' => 'KHR', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'KHM'],
            (object) ['name' => 'Cameroon', 'code' => 'CM', 'id' => 39, 'phone' => 237, 'symbol' => 'FCFA', 'capital' => 'Yaounde', 'currency' => 'XAF', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'CMR'],
            (object) ['name' => 'Canada', 'code' => 'CA', 'id' => 40, 'phone' => 1, 'symbol' => '$', 'capital' => 'Ottawa', 'currency' => 'CAD', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'CAN'],
            (object) ['name' => 'Cape Verde', 'code' => 'CV', 'id' => 41, 'phone' => 238, 'symbol' => '$', 'capital' => 'Praia', 'currency' => 'CVE', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'CPV'],
            (object) ['name' => 'Cayman Islands', 'code' => 'KY', 'id' => 42, 'phone' => 1345, 'symbol' => '$', 'capital' => 'George Town', 'currency' => 'KYD', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'CYM'],
            (object) ['name' => 'Central African Republic', 'code' => 'CF', 'id' => 43, 'phone' => 236, 'symbol' => 'FCFA', 'capital' => 'Bangui', 'currency' => 'XAF', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'CAF'],
            (object) ['name' => 'Chad', 'code' => 'TD', 'id' => 44, 'phone' => 235, 'symbol' => 'FCFA', 'capital' => "N'Djamena", 'currency' => 'XAF', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'TCD'],
            (object) ['name' => 'Chile', 'code' => 'CL', 'id' => 45, 'phone' => 56, 'symbol' => '$', 'capital' => 'Santiago', 'currency' => 'CLP', 'continent' => 'South America', 'continent_code' => 'SA', 'alpha_3' => 'CHL'],
            (object) ['name' => 'China', 'code' => 'CN', 'id' => 46, 'phone' => 86, 'symbol' => '¥', 'capital' => 'Beijing', 'currency' => 'CNY', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'CHN'],
            (object) ['name' => 'Christmas Island', 'code' => 'CX', 'id' => 47, 'phone' => 61, 'symbol' => '$', 'capital' => 'Flying Fish Cove', 'currency' => 'AUD', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'CXR'],
            (object) ['name' => 'Cocos (Keeling) Islands', 'code' => 'CC', 'id' => 48, 'phone' => 672, 'symbol' => '$', 'capital' => 'West Island', 'currency' => 'AUD', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'CCK'],
            (object) ['name' => 'Colombia', 'code' => 'CO', 'id' => 49, 'phone' => 57, 'symbol' => '$', 'capital' => 'Bogota', 'currency' => 'COP', 'continent' => 'South America', 'continent_code' => 'SA', 'alpha_3' => 'COL'],
            (object) ['name' => 'Comoros', 'code' => 'KM', 'id' => 50, 'phone' => 269, 'symbol' => 'CF', 'capital' => 'Moroni', 'currency' => 'KMF', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'COM'],
            (object) ['name' => 'Congo', 'code' => 'CG', 'id' => 51, 'phone' => 242, 'symbol' => 'FC', 'capital' => 'Brazzaville', 'currency' => 'XAF', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'COG'],
            (object) ['name' => 'Congo, Democratic Republic of the Congo', 'code' => 'CD', 'id' => 52, 'phone' => 242, 'symbol' => 'FC', 'capital' => 'Kinshasa', 'currency' => 'CDF', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'COD'],
            (object) ['name' => 'Cook Islands', 'code' => 'CK', 'id' => 53, 'phone' => 682, 'symbol' => '$', 'capital' => 'Avarua', 'currency' => 'NZD', 'continent' => 'Oceania', 'continent_code' => 'OC', 'alpha_3' => 'COK'],
            (object) ['name' => 'Costa Rica', 'code' => 'CR', 'id' => 54, 'phone' => 506, 'symbol' => '₡', 'capital' => 'San Jose', 'currency' => 'CRC', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'CRI'],
            (object) ['name' => "Cote D'Ivoire", 'code' => 'CI', 'id' => 55, 'phone' => 225, 'symbol' => 'CFA', 'capital' => 'Yamoussoukro', 'currency' => 'XOF', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'CIV'],
            (object) ['name' => 'Croatia', 'code' => 'HR', 'id' => 56, 'phone' => 385, 'symbol' => 'kn', 'capital' => 'Zagreb', 'currency' => 'HRK', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'HRV'],
            (object) ['name' => 'Cuba', 'code' => 'CU', 'id' => 57, 'phone' => 53, 'symbol' => '$', 'capital' => 'Havana', 'currency' => 'CUP', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'CUB'],
            (object) ['name' => 'Curacao', 'code' => 'CW', 'id' => 58, 'phone' => 599, 'symbol' => 'ƒ', 'capital' => 'Willemstad', 'currency' => 'ANG', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'CUW'],
            (object) ['name' => 'Cyprus', 'code' => 'CY', 'id' => 59, 'phone' => 357, 'symbol' => '€', 'capital' => 'Nicosia', 'currency' => 'EUR', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'CYP'],
            (object) ['name' => 'Czech Republic', 'code' => 'CZ', 'id' => 60, 'phone' => 420, 'symbol' => 'Kč', 'capital' => 'Prague', 'currency' => 'CZK', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'CZE'],
            (object) ['name' => 'Denmark', 'code' => 'DK', 'id' => 61, 'phone' => 45, 'symbol' => 'Kr.', 'capital' => 'Copenhagen', 'currency' => 'DKK', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'DNK'],
            (object) ['name' => 'Djibouti', 'code' => 'DJ', 'id' => 62, 'phone' => 253, 'symbol' => 'Fdj', 'capital' => 'Djibouti', 'currency' => 'DJF', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'DJI'],
            (object) ['name' => 'Dominica', 'code' => 'DM', 'id' => 63, 'phone' => 1767, 'symbol' => '$', 'capital' => 'Roseau', 'currency' => 'XCD', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'DMA'],
            (object) ['name' => 'Dominican Republic', 'code' => 'DO', 'id' => 64, 'phone' => 1809, 'symbol' => '$', 'capital' => 'Santo Domingo', 'currency' => 'DOP', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'DOM'],
            (object) ['name' => 'Ecuador', 'code' => 'EC', 'id' => 65, 'phone' => 593, 'symbol' => '$', 'capital' => 'Quito', 'currency' => 'USD', 'continent' => 'South America', 'continent_code' => 'SA', 'alpha_3' => 'ECU'],
            (object) ['name' => 'Egypt', 'code' => 'EG', 'id' => 66, 'phone' => 20, 'symbol' => 'ج.م', 'capital' => 'Cairo', 'currency' => 'EGP', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'EGY'],
            (object) ['name' => 'El Salvador', 'code' => 'SV', 'id' => 67, 'phone' => 503, 'symbol' => '$', 'capital' => 'San Salvador', 'currency' => 'USD', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'SLV'],
            (object) ['name' => 'Equatorial Guinea', 'code' => 'GQ', 'id' => 68, 'phone' => 240, 'symbol' => 'FCFA', 'capital' => 'Malabo', 'currency' => 'XAF', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'GNQ'],
            (object) ['name' => 'Eritrea', 'code' => 'ER', 'id' => 69, 'phone' => 291, 'symbol' => 'Nfk', 'capital' => 'Asmara', 'currency' => 'ERN', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'ERI'],
            (object) ['name' => 'Estonia', 'code' => 'EE', 'id' => 70, 'phone' => 372, 'symbol' => '€', 'capital' => 'Tallinn', 'currency' => 'EUR', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'EST'],
            (object) ['name' => 'Ethiopia', 'code' => 'ET', 'id' => 71, 'phone' => 251, 'symbol' => 'Nkf', 'capital' => 'Addis Ababa', 'currency' => 'ETB', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'ETH'],
            (object) ['name' => 'Falkland Islands (Malvinas)', 'code' => 'FK', 'id' => 72, 'phone' => 500, 'symbol' => '£', 'capital' => 'Stanley', 'currency' => 'FKP', 'continent' => 'South America', 'continent_code' => 'SA', 'alpha_3' => 'FLK'],
            (object) ['name' => 'Faroe Islands', 'code' => 'FO', 'id' => 73, 'phone' => 298, 'symbol' => 'Kr.', 'capital' => 'Torshavn', 'currency' => 'DKK', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'FRO'],
            (object) ['name' => 'Fiji', 'code' => 'FJ', 'id' => 74, 'phone' => 679, 'symbol' => 'FJ$', 'capital' => 'Suva', 'currency' => 'FJD', 'continent' => 'Oceania', 'continent_code' => 'OC', 'alpha_3' => 'FJI'],
            (object) ['name' => 'Finland', 'code' => 'FI', 'id' => 75, 'phone' => 358, 'symbol' => '€', 'capital' => 'Helsinki', 'currency' => 'EUR', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'FIN'],
            (object) ['name' => 'France', 'code' => 'FR', 'id' => 76, 'phone' => 33, 'symbol' => '€', 'capital' => 'Paris', 'currency' => 'EUR', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'FRA'],
            (object) ['name' => 'French Guiana', 'code' => 'GF', 'id' => 77, 'phone' => 594, 'symbol' => '€', 'capital' => 'Cayenne', 'currency' => 'EUR', 'continent' => 'South America', 'continent_code' => 'SA', 'alpha_3' => 'GUF'],
            (object) ['name' => 'French Polynesia', 'code' => 'PF', 'id' => 78, 'phone' => 689, 'symbol' => '₣', 'capital' => 'Papeete', 'currency' => 'XPF', 'continent' => 'Oceania', 'continent_code' => 'OC', 'alpha_3' => 'PYF'],
            (object) ['name' => 'French Southern Territories', 'code' => 'TF', 'id' => 79, 'phone' => 262, 'symbol' => '€', 'capital' => 'Port-aux-Francais', 'currency' => 'EUR', 'continent' => 'Antarctica', 'continent_code' => 'AN', 'alpha_3' => 'ATF'],
            (object) ['name' => 'Gabon', 'code' => 'GA', 'id' => 80, 'phone' => 241, 'symbol' => 'FCFA', 'capital' => 'Libreville', 'currency' => 'XAF', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'GAB'],
            (object) ['name' => 'Gambia', 'code' => 'GM', 'id' => 81, 'phone' => 220, 'symbol' => 'D', 'capital' => 'Banjul', 'currency' => 'GMD', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'GMB'],
            (object) ['name' => 'Georgia', 'code' => 'GE', 'id' => 82, 'phone' => 995, 'symbol' => 'ლ', 'capital' => 'Tbilisi', 'currency' => 'GEL', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'GEO'],
            (object) ['name' => 'Germany', 'code' => 'DE', 'id' => 83, 'phone' => 49, 'symbol' => '€', 'capital' => 'Berlin', 'currency' => 'EUR', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'DEU'],
            (object) ['name' => 'Ghana', 'code' => 'GH', 'id' => 84, 'phone' => 233, 'symbol' => 'GH₵', 'capital' => 'Accra', 'currency' => 'GHS', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'GHA'],
            (object) ['name' => 'Gibraltar', 'code' => 'GI', 'id' => 85, 'phone' => 350, 'symbol' => '£', 'capital' => 'Gibraltar', 'currency' => 'GIP', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'GIB'],
            (object) ['name' => 'Greece', 'code' => 'GR', 'id' => 86, 'phone' => 30, 'symbol' => '€', 'capital' => 'Athens', 'currency' => 'EUR', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'GRC'],
            (object) ['name' => 'Greenland', 'code' => 'GL', 'id' => 87, 'phone' => 299, 'symbol' => 'Kr.', 'capital' => 'Nuuk', 'currency' => 'DKK', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'GRL'],
            (object) ['name' => 'Grenada', 'code' => 'GD', 'id' => 88, 'phone' => 1473, 'symbol' => '$', 'capital' => "St. George's", 'currency' => 'XCD', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'GRD'],
            (object) ['name' => 'Guadeloupe', 'code' => 'GP', 'id' => 89, 'phone' => 590, 'symbol' => '€', 'capital' => 'Basse-Terre', 'currency' => 'EUR', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'GLP'],
            (object) ['name' => 'Guam', 'code' => 'GU', 'id' => 90, 'phone' => 1671, 'symbol' => '$', 'capital' => 'Hagatna', 'currency' => 'USD', 'continent' => 'Oceania', 'continent_code' => 'OC', 'alpha_3' => 'GUM'],
            (object) ['name' => 'Guatemala', 'code' => 'GT', 'id' => 91, 'phone' => 502, 'symbol' => 'Q', 'capital' => 'Guatemala City', 'currency' => 'GTQ', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'GTM'],
            (object) ['name' => 'Guernsey', 'code' => 'GG', 'id' => 92, 'phone' => 44, 'symbol' => '£', 'capital' => 'St Peter Port', 'currency' => 'GBP', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'GGY'],
            (object) ['name' => 'Guinea', 'code' => 'GN', 'id' => 93, 'phone' => 224, 'symbol' => 'FG', 'capital' => 'Conakry', 'currency' => 'GNF', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'GIN'],
            (object) ['name' => 'Guinea-Bissau', 'code' => 'GW', 'id' => 94, 'phone' => 245, 'symbol' => 'CFA', 'capital' => 'Bissau', 'currency' => 'XOF', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'GNB'],
            (object) ['name' => 'Guyana', 'code' => 'GY', 'id' => 95, 'phone' => 592, 'symbol' => '$', 'capital' => 'Georgetown', 'currency' => 'GYD', 'continent' => 'South America', 'continent_code' => 'SA', 'alpha_3' => 'GUY'],
            (object) ['name' => 'Haiti', 'code' => 'HT', 'id' => 96, 'phone' => 509, 'symbol' => 'G', 'capital' => 'Port-au-Prince', 'currency' => 'HTG', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'HTI'],
            (object) ['name' => 'Heard Island and McDonald Islands', 'code' => 'HM', 'id' => 97, 'phone' => 0, 'symbol' => '$', 'capital' => '', 'currency' => 'AUD', 'continent' => 'Antarctica', 'continent_code' => 'AN', 'alpha_3' => 'HMD'],
            (object) ['name' => 'Holy See (Vatican City State)', 'code' => 'VA', 'id' => 98, 'phone' => 39, 'symbol' => '€', 'capital' => 'Vatican City', 'currency' => 'EUR', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'VAT'],
            (object) ['name' => 'Honduras', 'code' => 'HN', 'id' => 99, 'phone' => 504, 'symbol' => 'L', 'capital' => 'Tegucigalpa', 'currency' => 'HNL', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'HND'],
            (object) ['name' => 'Hong Kong', 'code' => 'HK', 'id' => 100, 'phone' => 852, 'symbol' => '$', 'capital' => 'Hong Kong', 'currency' => 'HKD', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'HKG'],
            (object) ['name' => 'Hungary', 'code' => 'HU', 'id' => 101, 'phone' => 36, 'symbol' => 'Ft', 'capital' => 'Budapest', 'currency' => 'HUF', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'HUN'],
            (object) ['name' => 'Iceland', 'code' => 'IS', 'id' => 102, 'phone' => 354, 'symbol' => 'kr', 'capital' => 'Reykjavik', 'currency' => 'ISK', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'ISL'],
            (object) ['name' => 'India', 'code' => 'IN', 'id' => 103, 'phone' => 91, 'symbol' => '₹', 'capital' => 'New Delhi', 'currency' => 'INR', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'IND'],
            (object) ['name' => 'Indonesia', 'code' => 'ID', 'id' => 104, 'phone' => 62, 'symbol' => 'Rp', 'capital' => 'Jakarta', 'currency' => 'IDR', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'IDN'],
            (object) ['name' => 'Iran, Islamic Republic of', 'code' => 'IR', 'id' => 105, 'phone' => 98, 'symbol' => '﷼', 'capital' => 'Tehran', 'currency' => 'IRR', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'IRN'],
            (object) ['name' => 'Iraq', 'code' => 'IQ', 'id' => 106, 'phone' => 964, 'symbol' => 'د.ع', 'capital' => 'Baghdad', 'currency' => 'IQD', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'IRQ'],
            (object) ['name' => 'Ireland', 'code' => 'IE', 'id' => 107, 'phone' => 353, 'symbol' => '€', 'capital' => 'Dublin', 'currency' => 'EUR', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'IRL'],
            (object) ['name' => 'Isle of Man', 'code' => 'IM', 'id' => 108, 'phone' => 44, 'symbol' => '£', 'capital' => 'Douglas, Isle of Man', 'currency' => 'GBP', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'IMN'],
            (object) ['name' => 'Israel', 'code' => 'IL', 'id' => 109, 'phone' => 972, 'symbol' => '₪', 'capital' => 'Jerusalem', 'currency' => 'ILS', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'ISR'],
            (object) ['name' => 'Italy', 'code' => 'IT', 'id' => 110, 'phone' => 39, 'symbol' => '€', 'capital' => 'Rome', 'currency' => 'EUR', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'ITA'],
            (object) ['name' => 'Jamaica', 'code' => 'JM', 'id' => 111, 'phone' => 1876, 'symbol' => 'J$', 'capital' => 'Kingston', 'currency' => 'JMD', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'JAM'],
            (object) ['name' => 'Japan', 'code' => 'JP', 'id' => 112, 'phone' => 81, 'symbol' => '¥', 'capital' => 'Tokyo', 'currency' => 'JPY', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'JPN'],
            (object) ['name' => 'Jersey', 'code' => 'JE', 'id' => 113, 'phone' => 44, 'symbol' => '£', 'capital' => 'Saint Helier', 'currency' => 'GBP', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'JEY'],
            (object) ['name' => 'Jordan', 'code' => 'JO', 'id' => 114, 'phone' => 962, 'symbol' => 'ا.د', 'capital' => 'Amman', 'currency' => 'JOD', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'JOR'],
            (object) ['name' => 'Kazakhstan', 'code' => 'KZ', 'id' => 115, 'phone' => 7, 'symbol' => 'лв', 'capital' => 'Astana', 'currency' => 'KZT', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'KAZ'],
            (object) ['name' => 'Kenya', 'code' => 'KE', 'id' => 116, 'phone' => 254, 'symbol' => 'KSh', 'capital' => 'Nairobi', 'currency' => 'KES', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'KEN'],
            (object) ['name' => 'Kiribati', 'code' => 'KI', 'id' => 117, 'phone' => 686, 'symbol' => '$', 'capital' => 'Tarawa', 'currency' => 'AUD', 'continent' => 'Oceania', 'continent_code' => 'OC', 'alpha_3' => 'KIR'],
            (object) ['name' => "Korea, Democratic People's Republic of", 'code' => 'KP', 'id' => 118, 'phone' => 850, 'symbol' => '₩', 'capital' => 'Pyongyang', 'currency' => 'KPW', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'PRK'],
            (object) ['name' => 'Korea, Republic of', 'code' => 'KR', 'id' => 119, 'phone' => 82, 'symbol' => '₩', 'capital' => 'Seoul', 'currency' => 'KRW', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'KOR'],
            (object) ['name' => 'Kosovo', 'code' => 'XK', 'id' => 120, 'phone' => 383, 'symbol' => '€', 'capital' => 'Pristina', 'currency' => 'EUR', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'XKX'],
            (object) ['name' => 'Kuwait', 'code' => 'KW', 'id' => 121, 'phone' => 965, 'symbol' => 'ك.د', 'capital' => 'Kuwait City', 'currency' => 'KWD', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'KWT'],
            (object) ['name' => 'Kyrgyzstan', 'code' => 'KG', 'id' => 122, 'phone' => 996, 'symbol' => 'лв', 'capital' => 'Bishkek', 'currency' => 'KGS', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'KGZ'],
            (object) ['name' => "Lao People's Democratic Republic", 'code' => 'LA', 'id' => 123, 'phone' => 856, 'symbol' => '₭', 'capital' => 'Vientiane', 'currency' => 'LAK', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'LAO'],
            (object) ['name' => 'Latvia', 'code' => 'LV', 'id' => 124, 'phone' => 371, 'symbol' => '€', 'capital' => 'Riga', 'currency' => 'EUR', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'LVA'],
            (object) ['name' => 'Lebanon', 'code' => 'LB', 'id' => 125, 'phone' => 961, 'symbol' => '£', 'capital' => 'Beirut', 'currency' => 'LBP', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'LBN'],
            (object) ['name' => 'Lesotho', 'code' => 'LS', 'id' => 126, 'phone' => 266, 'symbol' => 'L', 'capital' => 'Maseru', 'currency' => 'LSL', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'LSO'],
            (object) ['name' => 'Liberia', 'code' => 'LR', 'id' => 127, 'phone' => 231, 'symbol' => '$', 'capital' => 'Monrovia', 'currency' => 'LRD', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'LBR'],
            (object) ['name' => 'Libyan Arab Jamahiriya', 'code' => 'LY', 'id' => 128, 'phone' => 218, 'symbol' => 'د.ل', 'capital' => 'Tripolis', 'currency' => 'LYD', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'LBY'],
            (object) ['name' => 'Liechtenstein', 'code' => 'LI', 'id' => 129, 'phone' => 423, 'symbol' => 'CHf', 'capital' => 'Vaduz', 'currency' => 'CHF', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'LIE'],
            (object) ['name' => 'Lithuania', 'code' => 'LT', 'id' => 130, 'phone' => 370, 'symbol' => '€', 'capital' => 'Vilnius', 'currency' => 'EUR', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'LTU'],
            (object) ['name' => 'Luxembourg', 'code' => 'LU', 'id' => 131, 'phone' => 352, 'symbol' => '€', 'capital' => 'Luxembourg', 'currency' => 'EUR', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'LUX'],
            (object) ['name' => 'Macao', 'code' => 'MO', 'id' => 132, 'phone' => 853, 'symbol' => '$', 'capital' => 'Macao', 'currency' => 'MOP', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'MAC'],
            (object) ['name' => 'Macedonia, the Former Yugoslav Republic of', 'code' => 'MK', 'id' => 133, 'phone' => 389, 'symbol' => 'ден', 'capital' => 'Skopje', 'currency' => 'MKD', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'MKD'],
            (object) ['name' => 'Madagascar', 'code' => 'MG', 'id' => 134, 'phone' => 261, 'symbol' => 'Ar', 'capital' => 'Antananarivo', 'currency' => 'MGA', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'MDG'],
            (object) ['name' => 'Malawi', 'code' => 'MW', 'id' => 135, 'phone' => 265, 'symbol' => 'MK', 'capital' => 'Lilongwe', 'currency' => 'MWK', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'MWI'],
            (object) ['name' => 'Malaysia', 'code' => 'MY', 'id' => 136, 'phone' => 60, 'symbol' => 'RM', 'capital' => 'Kuala Lumpur', 'currency' => 'MYR', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'MYS'],
            (object) ['name' => 'Maldives', 'code' => 'MV', 'id' => 137, 'phone' => 960, 'symbol' => 'Rf', 'capital' => 'Male', 'currency' => 'MVR', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'MDV'],
            (object) ['name' => 'Mali', 'code' => 'ML', 'id' => 138, 'phone' => 223, 'symbol' => 'CFA', 'capital' => 'Bamako', 'currency' => 'XOF', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'MLI'],
            (object) ['name' => 'Malta', 'code' => 'MT', 'id' => 139, 'phone' => 356, 'symbol' => '€', 'capital' => 'Valletta', 'currency' => 'EUR', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'MLT'],
            (object) ['name' => 'Marshall Islands', 'code' => 'MH', 'id' => 140, 'phone' => 692, 'symbol' => '$', 'capital' => 'Majuro', 'currency' => 'USD', 'continent' => 'Oceania', 'continent_code' => 'OC', 'alpha_3' => 'MHL'],
            (object) ['name' => 'Martinique', 'code' => 'MQ', 'id' => 141, 'phone' => 596, 'symbol' => '€', 'capital' => 'Fort-de-France', 'currency' => 'EUR', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'MTQ'],
            (object) ['name' => 'Mauritania', 'code' => 'MR', 'id' => 142, 'phone' => 222, 'symbol' => 'MRU', 'capital' => 'Nouakchott', 'currency' => 'MRO', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'MRT'],
            (object) ['name' => 'Mauritius', 'code' => 'MU', 'id' => 143, 'phone' => 230, 'symbol' => '₨', 'capital' => 'Port Louis', 'currency' => 'MUR', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'MUS'],
            (object) ['name' => 'Mayotte', 'code' => 'YT', 'id' => 144, 'phone' => 262, 'symbol' => '€', 'capital' => 'Mamoudzou', 'currency' => 'EUR', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'MYT'],
            (object) ['name' => 'Mexico', 'code' => 'MX', 'id' => 145, 'phone' => 52, 'symbol' => '$', 'capital' => 'Mexico City', 'currency' => 'MXN', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'MEX'],
            (object) ['name' => 'Micronesia, Federated States of', 'code' => 'FM', 'id' => 146, 'phone' => 691, 'symbol' => '$', 'capital' => 'Palikir', 'currency' => 'USD', 'continent' => 'Oceania', 'continent_code' => 'OC', 'alpha_3' => 'FSM'],
            (object) ['name' => 'Moldova, Republic of', 'code' => 'MD', 'id' => 147, 'phone' => 373, 'symbol' => 'L', 'capital' => 'Chisinau', 'currency' => 'MDL', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'MDA'],
            (object) ['name' => 'Monaco', 'code' => 'MC', 'id' => 148, 'phone' => 377, 'symbol' => '€', 'capital' => 'Monaco', 'currency' => 'EUR', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'MCO'],
            (object) ['name' => 'Mongolia', 'code' => 'MN', 'id' => 149, 'phone' => 976, 'symbol' => '₮', 'capital' => 'Ulan Bator', 'currency' => 'MNT', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'MNG'],
            (object) ['name' => 'Montenegro', 'code' => 'ME', 'id' => 150, 'phone' => 382, 'symbol' => '€', 'capital' => 'Podgorica', 'currency' => 'EUR', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'MNE'],
            (object) ['name' => 'Montserrat', 'code' => 'MS', 'id' => 151, 'phone' => 1664, 'symbol' => '$', 'capital' => 'Plymouth', 'currency' => 'XCD', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'MSR'],
            (object) ['name' => 'Morocco', 'code' => 'MA', 'id' => 152, 'phone' => 212, 'symbol' => 'DH', 'capital' => 'Rabat', 'currency' => 'MAD', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'MAR'],
            (object) ['name' => 'Mozambique', 'code' => 'MZ', 'id' => 153, 'phone' => 258, 'symbol' => 'MT', 'capital' => 'Maputo', 'currency' => 'MZN', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'MOZ'],
            (object) ['name' => 'Myanmar', 'code' => 'MM', 'id' => 154, 'phone' => 95, 'symbol' => 'K', 'capital' => 'Nay Pyi Taw', 'currency' => 'MMK', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'MMR'],
            (object) ['name' => 'Namibia', 'code' => 'NA', 'id' => 155, 'phone' => 264, 'symbol' => '$', 'capital' => 'Windhoek', 'currency' => 'NAD', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'NAM'],
            (object) ['name' => 'Nauru', 'code' => 'NR', 'id' => 156, 'phone' => 674, 'symbol' => '$', 'capital' => 'Yaren', 'currency' => 'AUD', 'continent' => 'Oceania', 'continent_code' => 'OC', 'alpha_3' => 'NRU'],
            (object) ['name' => 'Nepal', 'code' => 'NP', 'id' => 157, 'phone' => 977, 'symbol' => '₨', 'capital' => 'Kathmandu', 'currency' => 'NPR', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'NPL'],
            (object) ['name' => 'Netherlands', 'code' => 'NL', 'id' => 158, 'phone' => 31, 'symbol' => '€', 'capital' => 'Amsterdam', 'currency' => 'EUR', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'NLD'],
            (object) ['name' => 'Netherlands Antilles', 'code' => 'AN', 'id' => 159, 'phone' => 599, 'symbol' => 'NAf', 'capital' => 'Willemstad', 'currency' => 'ANG', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'ANT'],
            (object) ['name' => 'New Caledonia', 'code' => 'NC', 'id' => 160, 'phone' => 687, 'symbol' => '₣', 'capital' => 'Noumea', 'currency' => 'XPF', 'continent' => 'Oceania', 'continent_code' => 'OC', 'alpha_3' => 'NCL'],
            (object) ['name' => 'New Zealand', 'code' => 'NZ', 'id' => 161, 'phone' => 64, 'symbol' => '$', 'capital' => 'Wellington', 'currency' => 'NZD', 'continent' => 'Oceania', 'continent_code' => 'OC', 'alpha_3' => 'NZL'],
            (object) ['name' => 'Nicaragua', 'code' => 'NI', 'id' => 162, 'phone' => 505, 'symbol' => 'C$', 'capital' => 'Managua', 'currency' => 'NIO', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'NIC'],
            (object) ['name' => 'Niger', 'code' => 'NE', 'id' => 163, 'phone' => 227, 'symbol' => 'CFA', 'capital' => 'Niamey', 'currency' => 'XOF', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'NER'],
            (object) ['name' => 'Nigeria', 'code' => 'NG', 'id' => 164, 'phone' => 234, 'symbol' => '₦', 'capital' => 'Abuja', 'currency' => 'NGN', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'NGA'],
            (object) ['name' => 'Niue', 'code' => 'NU', 'id' => 165, 'phone' => 683, 'symbol' => '$', 'capital' => 'Alofi', 'currency' => 'NZD', 'continent' => 'Oceania', 'continent_code' => 'OC', 'alpha_3' => 'NIU'],
            (object) ['name' => 'Norfolk Island', 'code' => 'NF', 'id' => 166, 'phone' => 672, 'symbol' => '$', 'capital' => 'Kingston', 'currency' => 'AUD', 'continent' => 'Oceania', 'continent_code' => 'OC', 'alpha_3' => 'NFK'],
            (object) ['name' => 'Northern Mariana Islands', 'code' => 'MP', 'id' => 167, 'phone' => 1670, 'symbol' => '$', 'capital' => 'Saipan', 'currency' => 'USD', 'continent' => 'Oceania', 'continent_code' => 'OC', 'alpha_3' => 'MNP'],
            (object) ['name' => 'Norway', 'code' => 'NO', 'id' => 168, 'phone' => 47, 'symbol' => 'kr', 'capital' => 'Oslo', 'currency' => 'NOK', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'NOR'],
            (object) ['name' => 'Oman', 'code' => 'OM', 'id' => 169, 'phone' => 968, 'symbol' => '.ع.ر', 'capital' => 'Muscat', 'currency' => 'OMR', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'OMN'],
            (object) ['name' => 'Pakistan', 'code' => 'PK', 'id' => 170, 'phone' => 92, 'symbol' => '₨', 'capital' => 'Islamabad', 'currency' => 'PKR', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'PAK'],
            (object) ['name' => 'Palau', 'code' => 'PW', 'id' => 171, 'phone' => 680, 'symbol' => '$', 'capital' => 'Melekeok', 'currency' => 'USD', 'continent' => 'Oceania', 'continent_code' => 'OC', 'alpha_3' => 'PLW'],
            (object) ['name' => 'Palestinian Territory, Occupied', 'code' => 'PS', 'id' => 172, 'phone' => 970, 'symbol' => '₪', 'capital' => 'East Jerusalem', 'currency' => 'ILS', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'PSE'],
            (object) ['name' => 'Panama', 'code' => 'PA', 'id' => 173, 'phone' => 507, 'symbol' => 'B/.', 'capital' => 'Panama City', 'currency' => 'PAB', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'PAN'],
            (object) ['name' => 'Papua New Guinea', 'code' => 'PG', 'id' => 174, 'phone' => 675, 'symbol' => 'K', 'capital' => 'Port Moresby', 'currency' => 'PGK', 'continent' => 'Oceania', 'continent_code' => 'OC', 'alpha_3' => 'PNG'],
            (object) ['name' => 'Paraguay', 'code' => 'PY', 'id' => 175, 'phone' => 595, 'symbol' => '₲', 'capital' => 'Asuncion', 'currency' => 'PYG', 'continent' => 'South America', 'continent_code' => 'SA', 'alpha_3' => 'PRY'],
            (object) ['name' => 'Peru', 'code' => 'PE', 'id' => 176, 'phone' => 51, 'symbol' => 'S/.', 'capital' => 'Lima', 'currency' => 'PEN', 'continent' => 'South America', 'continent_code' => 'SA', 'alpha_3' => 'PER'],
            (object) ['name' => 'Philippines', 'code' => 'PH', 'id' => 177, 'phone' => 63, 'symbol' => '₱', 'capital' => 'Manila', 'currency' => 'PHP', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'PHL'],
            (object) ['name' => 'Pitcairn', 'code' => 'PN', 'id' => 178, 'phone' => 64, 'symbol' => '$', 'capital' => 'Adamstown', 'currency' => 'NZD', 'continent' => 'Oceania', 'continent_code' => 'OC', 'alpha_3' => 'PCN'],
            (object) ['name' => 'Poland', 'code' => 'PL', 'id' => 179, 'phone' => 48, 'symbol' => 'zł', 'capital' => 'Warsaw', 'currency' => 'PLN', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'POL'],
            (object) ['name' => 'Portugal', 'code' => 'PT', 'id' => 180, 'phone' => 351, 'symbol' => '€', 'capital' => 'Lisbon', 'currency' => 'EUR', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'PRT'],
            (object) ['name' => 'Puerto Rico', 'code' => 'PR', 'id' => 181, 'phone' => 1787, 'symbol' => '$', 'capital' => 'San Juan', 'currency' => 'USD', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'PRI'],
            (object) ['name' => 'Qatar', 'code' => 'QA', 'id' => 182, 'phone' => 974, 'symbol' => 'ق.ر', 'capital' => 'Doha', 'currency' => 'QAR', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'QAT'],
            (object) ['name' => 'Reunion', 'code' => 'RE', 'id' => 183, 'phone' => 262, 'symbol' => '€', 'capital' => 'Saint-Denis', 'currency' => 'EUR', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'REU'],
            (object) ['name' => 'Romania', 'code' => 'RO', 'id' => 184, 'phone' => 40, 'symbol' => 'lei', 'capital' => 'Bucharest', 'currency' => 'RON', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'ROM'],
            (object) ['name' => 'Russian Federation', 'code' => 'RU', 'id' => 185, 'phone' => 7, 'symbol' => '₽', 'capital' => 'Moscow', 'currency' => 'RUB', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'RUS'],
            (object) ['name' => 'Rwanda', 'code' => 'RW', 'id' => 186, 'phone' => 250, 'symbol' => 'FRw', 'capital' => 'Kigali', 'currency' => 'RWF', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'RWA'],
            (object) ['name' => 'Saint Barthelemy', 'code' => 'BL', 'id' => 187, 'phone' => 590, 'symbol' => '€', 'capital' => 'Gustavia', 'currency' => 'EUR', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'BLM'],
            (object) ['name' => 'Saint Helena', 'code' => 'SH', 'id' => 188, 'phone' => 290, 'symbol' => '£', 'capital' => 'Jamestown', 'currency' => 'SHP', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'SHN'],
            (object) ['name' => 'Saint Kitts and Nevis', 'code' => 'KN', 'id' => 189, 'phone' => 1869, 'symbol' => '$', 'capital' => 'Basseterre', 'currency' => 'XCD', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'KNA'],
            (object) ['name' => 'Saint Lucia', 'code' => 'LC', 'id' => 190, 'phone' => 1758, 'symbol' => '$', 'capital' => 'Castries', 'currency' => 'XCD', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'LCA'],
            (object) ['name' => 'Saint Martin', 'code' => 'MF', 'id' => 191, 'phone' => 590, 'symbol' => '€', 'capital' => 'Marigot', 'currency' => 'EUR', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'MAF'],
            (object) ['name' => 'Saint Pierre and Miquelon', 'code' => 'PM', 'id' => 192, 'phone' => 508, 'symbol' => '€', 'capital' => 'Saint-Pierre', 'currency' => 'EUR', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'SPM'],
            (object) ['name' => 'Saint Vincent and the Grenadines', 'code' => 'VC', 'id' => 193, 'phone' => 1784, 'symbol' => '$', 'capital' => 'Kingstown', 'currency' => 'XCD', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'VCT'],
            (object) ['name' => 'Samoa', 'code' => 'WS', 'id' => 194, 'phone' => 684, 'symbol' => 'SAT', 'capital' => 'Apia', 'currency' => 'WST', 'continent' => 'Oceania', 'continent_code' => 'OC', 'alpha_3' => 'WSM'],
            (object) ['name' => 'San Marino', 'code' => 'SM', 'id' => 195, 'phone' => 378, 'symbol' => '€', 'capital' => 'San Marino', 'currency' => 'EUR', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'SMR'],
            (object) ['name' => 'Sao Tome and Principe', 'code' => 'ST', 'id' => 196, 'phone' => 239, 'symbol' => 'Db', 'capital' => 'Sao Tome', 'currency' => 'STD', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'STP'],
            (object) ['name' => 'Saudi Arabia', 'code' => 'SA', 'id' => 197, 'phone' => 966, 'symbol' => '﷼', 'capital' => 'Riyadh', 'currency' => 'SAR', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'SAU'],
            (object) ['name' => 'Senegal', 'code' => 'SN', 'id' => 198, 'phone' => 221, 'symbol' => 'CFA', 'capital' => 'Dakar', 'currency' => 'XOF', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'SEN'],
            (object) ['name' => 'Serbia', 'code' => 'RS', 'id' => 199, 'phone' => 381, 'symbol' => 'din', 'capital' => 'Belgrade', 'currency' => 'RSD', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'SRB'],
            (object) ['name' => 'Serbia and Montenegro', 'code' => 'CS', 'id' => 200, 'phone' => 381, 'symbol' => 'din', 'capital' => 'Belgrade', 'currency' => 'RSD', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'SCG'],
            (object) ['name' => 'Seychelles', 'code' => 'SC', 'id' => 201, 'phone' => 248, 'symbol' => 'SRe', 'capital' => 'Victoria', 'currency' => 'SCR', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'SYC'],
            (object) ['name' => 'Sierra Leone', 'code' => 'SL', 'id' => 202, 'phone' => 232, 'symbol' => 'Le', 'capital' => 'Freetown', 'currency' => 'SLL', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'SLE'],
            (object) ['name' => 'Singapore', 'code' => 'SG', 'id' => 203, 'phone' => 65, 'symbol' => '$', 'capital' => 'Singapur', 'currency' => 'SGD', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'SGP'],
            (object) ['name' => 'St Martin', 'code' => 'SX', 'id' => 204, 'phone' => 721, 'symbol' => 'ƒ', 'capital' => 'Philipsburg', 'currency' => 'ANG', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'SXM'],
            (object) ['name' => 'Slovakia', 'code' => 'SK', 'id' => 205, 'phone' => 421, 'symbol' => '€', 'capital' => 'Bratislava', 'currency' => 'EUR', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'SVK'],
            (object) ['name' => 'Slovenia', 'code' => 'SI', 'id' => 206, 'phone' => 386, 'symbol' => '€', 'capital' => 'Ljubljana', 'currency' => 'EUR', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'SVN'],
            (object) ['name' => 'Solomon Islands', 'code' => 'SB', 'id' => 207, 'phone' => 677, 'symbol' => 'Si$', 'capital' => 'Honiara', 'currency' => 'SBD', 'continent' => 'Oceania', 'continent_code' => 'OC', 'alpha_3' => 'SLB'],
            (object) ['name' => 'Somalia', 'code' => 'SO', 'id' => 208, 'phone' => 252, 'symbol' => 'Sh.so.', 'capital' => 'Mogadishu', 'currency' => 'SOS', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'SOM'],
            (object) ['name' => 'South Africa', 'code' => 'ZA', 'id' => 209, 'phone' => 27, 'symbol' => 'R', 'capital' => 'Pretoria', 'currency' => 'ZAR', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'ZAF'],
            (object) ['name' => 'South Georgia and the South Sandwich Islands', 'code' => 'GS', 'id' => 210, 'phone' => 500, 'symbol' => '£', 'capital' => 'Grytviken', 'currency' => 'GBP', 'continent' => 'Antarctica', 'continent_code' => 'AN', 'alpha_3' => 'SGS'],
            (object) ['name' => 'South Sudan', 'code' => 'SS', 'id' => 211, 'phone' => 211, 'symbol' => '£', 'capital' => 'Juba', 'currency' => 'SSP', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'SSD'],
            (object) ['name' => 'Spain', 'code' => 'ES', 'id' => 212, 'phone' => 34, 'symbol' => '€', 'capital' => 'Madrid', 'currency' => 'EUR', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'ESP'],
            (object) ['name' => 'Sri Lanka', 'code' => 'LK', 'id' => 213, 'phone' => 94, 'symbol' => 'Rs', 'capital' => 'Colombo', 'currency' => 'LKR', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'LKA'],
            (object) ['name' => 'Sudan', 'code' => 'SD', 'id' => 214, 'phone' => 249, 'symbol' => '.س.ج', 'capital' => 'Khartoum', 'currency' => 'SDG', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'SDN'],
            (object) ['name' => 'Suriname', 'code' => 'SR', 'id' => 215, 'phone' => 597, 'symbol' => '$', 'capital' => 'Paramaribo', 'currency' => 'SRD', 'continent' => 'South America', 'continent_code' => 'SA', 'alpha_3' => 'SUR'],
            (object) ['name' => 'Svalbard and Jan Mayen', 'code' => 'SJ', 'id' => 216, 'phone' => 47, 'symbol' => 'kr', 'capital' => 'Longyearbyen', 'currency' => 'NOK', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'SJM'],
            (object) ['name' => 'Swaziland', 'code' => 'SZ', 'id' => 217, 'phone' => 268, 'symbol' => 'E', 'capital' => 'Mbabane', 'currency' => 'SZL', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'SWZ'],
            (object) ['name' => 'Sweden', 'code' => 'SE', 'id' => 218, 'phone' => 46, 'symbol' => 'kr', 'capital' => 'Stockholm', 'currency' => 'SEK', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'SWE'],
            (object) ['name' => 'Switzerland', 'code' => 'CH', 'id' => 219, 'phone' => 41, 'symbol' => 'CHf', 'capital' => 'Berne', 'currency' => 'CHF', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'CHE'],
            (object) ['name' => 'Syrian Arab Republic', 'code' => 'SY', 'id' => 220, 'phone' => 963, 'symbol' => 'LS', 'capital' => 'Damascus', 'currency' => 'SYP', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'SYR'],
            (object) ['name' => 'Taiwan, Province of China', 'code' => 'TW', 'id' => 221, 'phone' => 886, 'symbol' => '$', 'capital' => 'Taipei', 'currency' => 'TWD', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'TWN'],
            (object) ['name' => 'Tajikistan', 'code' => 'TJ', 'id' => 222, 'phone' => 992, 'symbol' => 'SM', 'capital' => 'Dushanbe', 'currency' => 'TJS', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'TJK'],
            (object) ['name' => 'Tanzania, United Republic of', 'code' => 'TZ', 'id' => 223, 'phone' => 255, 'symbol' => 'TSh', 'capital' => 'Dodoma', 'currency' => 'TZS', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'TZA'],
            (object) ['name' => 'Thailand', 'code' => 'TH', 'id' => 224, 'phone' => 66, 'symbol' => '฿', 'capital' => 'Bangkok', 'currency' => 'THB', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'THA'],
            (object) ['name' => 'Timor-Leste', 'code' => 'TL', 'id' => 225, 'phone' => 670, 'symbol' => '$', 'capital' => 'Dili', 'currency' => 'USD', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'TLS'],
            (object) ['name' => 'Togo', 'code' => 'TG', 'id' => 226, 'phone' => 228, 'symbol' => 'CFA', 'capital' => 'Lome', 'currency' => 'XOF', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'TGO'],
            (object) ['name' => 'Tokelau', 'code' => 'TK', 'id' => 227, 'phone' => 690, 'symbol' => '$', 'capital' => '', 'currency' => 'NZD', 'continent' => 'Oceania', 'continent_code' => 'OC', 'alpha_3' => 'TKL'],
            (object) ['name' => 'Tonga', 'code' => 'TO', 'id' => 228, 'phone' => 676, 'symbol' => '$', 'capital' => "Nuku'alofa", 'currency' => 'TOP', 'continent' => 'Oceania', 'continent_code' => 'OC', 'alpha_3' => 'TON'],
            (object) ['name' => 'Trinidad and Tobago', 'code' => 'TT', 'id' => 229, 'phone' => 1868, 'symbol' => '$', 'capital' => 'Port of Spain', 'currency' => 'TTD', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'TTO'],
            (object) ['name' => 'Tunisia', 'code' => 'TN', 'id' => 230, 'phone' => 216, 'symbol' => 'ت.د', 'capital' => 'Tunis', 'currency' => 'TND', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'TUN'],
            (object) ['name' => 'Turkey', 'code' => 'TR', 'id' => 231, 'phone' => 90, 'symbol' => '₺', 'capital' => 'Ankara', 'currency' => 'TRY', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'TUR'],
            (object) ['name' => 'Turkmenistan', 'code' => 'TM', 'id' => 232, 'phone' => 7370, 'symbol' => 'T', 'capital' => 'Ashgabat', 'currency' => 'TMT', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'TKM'],
            (object) ['name' => 'Turks and Caicos Islands', 'code' => 'TC', 'id' => 233, 'phone' => 1649, 'symbol' => '$', 'capital' => 'Cockburn Town', 'currency' => 'USD', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'TCA'],
            (object) ['name' => 'Tuvalu', 'code' => 'TV', 'id' => 234, 'phone' => 688, 'symbol' => '$', 'capital' => 'Funafuti', 'currency' => 'AUD', 'continent' => 'Oceania', 'continent_code' => 'OC', 'alpha_3' => 'TUV'],
            (object) ['name' => 'Uganda', 'code' => 'UG', 'id' => 235, 'phone' => 256, 'symbol' => 'USh', 'capital' => 'Kampala', 'currency' => 'UGX', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'UGA'],
            (object) ['name' => 'Ukraine', 'code' => 'UA', 'id' => 236, 'phone' => 380, 'symbol' => '₴', 'capital' => 'Kiev', 'currency' => 'UAH', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'UKR'],
            (object) ['name' => 'United Arab Emirates', 'code' => 'AE', 'id' => 237, 'phone' => 971, 'symbol' => 'إ.د', 'capital' => 'Abu Dhabi', 'currency' => 'AED', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'ARE'],
            (object) ['name' => 'United Kingdom', 'code' => 'GB', 'id' => 238, 'phone' => 44, 'symbol' => '£', 'capital' => 'London', 'currency' => 'GBP', 'continent' => 'Europe', 'continent_code' => 'EU', 'alpha_3' => 'GBR'],
            (object) ['name' => 'United States', 'code' => 'US', 'id' => 239, 'phone' => 1, 'symbol' => '$', 'capital' => 'Washington', 'currency' => 'USD', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'USA'],
            (object) ['name' => 'United States Minor Outlying Islands', 'code' => 'UM', 'id' => 240, 'phone' => 1, 'symbol' => '$', 'capital' => '', 'currency' => 'USD', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'UMI'],
            (object) ['name' => 'Uruguay', 'code' => 'UY', 'id' => 241, 'phone' => 598, 'symbol' => '$', 'capital' => 'Montevideo', 'currency' => 'UYU', 'continent' => 'South America', 'continent_code' => 'SA', 'alpha_3' => 'URY'],
            (object) ['name' => 'Uzbekistan', 'code' => 'UZ', 'id' => 242, 'phone' => 998, 'symbol' => 'лв', 'capital' => 'Tashkent', 'currency' => 'UZS', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'UZB'],
            (object) ['name' => 'Vanuatu', 'code' => 'VU', 'id' => 243, 'phone' => 678, 'symbol' => 'VT', 'capital' => 'Port Vila', 'currency' => 'VUV', 'continent' => 'Oceania', 'continent_code' => 'OC', 'alpha_3' => 'VUT'],
            (object) ['name' => 'Venezuela', 'code' => 'VE', 'id' => 244, 'phone' => 58, 'symbol' => 'Bs', 'capital' => 'Caracas', 'currency' => 'VEF', 'continent' => 'South America', 'continent_code' => 'SA', 'alpha_3' => 'VEN'],
            (object) ['name' => 'Viet Nam', 'code' => 'VN', 'id' => 245, 'phone' => 84, 'symbol' => '₫', 'capital' => 'Hanoi', 'currency' => 'VND', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'VNM'],
            (object) ['name' => 'Virgin Islands, British', 'code' => 'VG', 'id' => 246, 'phone' => 1284, 'symbol' => '$', 'capital' => 'Road Town', 'currency' => 'USD', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'VGB'],
            (object) ['name' => 'Virgin Islands, U.s.', 'code' => 'VI', 'id' => 247, 'phone' => 1340, 'symbol' => '$', 'capital' => 'Charlotte Amalie', 'currency' => 'USD', 'continent' => 'North America', 'continent_code' => 'NA', 'alpha_3' => 'VIR'],
            (object) ['name' => 'Wallis and Futuna', 'code' => 'WF', 'id' => 248, 'phone' => 681, 'symbol' => '₣', 'capital' => 'Mata Utu', 'currency' => 'XPF', 'continent' => 'Oceania', 'continent_code' => 'OC', 'alpha_3' => 'WLF'],
            (object) ['name' => 'Western Sahara', 'code' => 'EH', 'id' => 249, 'phone' => 212, 'symbol' => 'MAD', 'capital' => 'El-Aaiun', 'currency' => 'MAD', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'ESH'],
            (object) ['name' => 'Yemen', 'code' => 'YE', 'id' => 250, 'phone' => 967, 'symbol' => '﷼', 'capital' => 'Sanaa', 'currency' => 'YER', 'continent' => 'Asia', 'continent_code' => 'AS', 'alpha_3' => 'YEM'],
            (object) ['name' => 'Zambia', 'code' => 'ZM', 'id' => 251, 'phone' => 260, 'symbol' => 'ZK', 'capital' => 'Lusaka', 'currency' => 'ZMW', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'ZMB'],
            (object) ['name' => 'Zimbabwe', 'code' => 'ZW', 'id' => 252, 'phone' => 263, 'symbol' => '$', 'capital' => 'Harare', 'currency' => 'ZWL', 'continent' => 'Africa', 'continent_code' => 'AF', 'alpha_3' => 'ZWE'],
        ]);
    }

    public static function getLanguages(): Collection
    {
        $languages = [
            (object) ['name' => 'Abkhazian', 'code' => 'ab'],
            (object) ['name' => 'Afar', 'code' => 'aa'],
            (object) ['name' => 'Afrikaans', 'code' => 'af'],
            (object) ['name' => 'Akan', 'code' => 'ak'],
            (object) ['name' => 'Albanian', 'code' => 'sq'],
            (object) ['name' => 'Amharic', 'code' => 'am'],
            (object) ['name' => 'Arabic', 'code' => 'ar'],
            (object) ['name' => 'Aragonese', 'code' => 'an'],
            (object) ['name' => 'Armenian', 'code' => 'hy'],
            (object) ['name' => 'Assamese', 'code' => 'as'],
            (object) ['name' => 'Avaric', 'code' => 'av'],
            (object) ['name' => 'Avestan', 'code' => 'ae'],
            (object) ['name' => 'Aymara', 'code' => 'ay'],
            (object) ['name' => 'Azerbaijani', 'code' => 'az'],
            (object) ['name' => 'Bambara', 'code' => 'bm'],
            (object) ['name' => 'Bashkir', 'code' => 'ba'],
            (object) ['name' => 'Basque', 'code' => 'eu'],
            (object) ['name' => 'Belarusian', 'code' => 'be'],
            (object) ['name' => 'Bengali', 'code' => 'bn'],
            (object) ['name' => 'Bihari', 'code' => 'bh'],
            (object) ['name' => 'Bislama', 'code' => 'bi'],
            (object) ['name' => 'Bosnian', 'code' => 'bs'],
            (object) ['name' => 'Breton', 'code' => 'br'],
            (object) ['name' => 'Bulgarian', 'code' => 'bg'],
            (object) ['name' => 'Burmese', 'code' => 'my'],
            (object) ['name' => 'Catalan', 'code' => 'ca'],
            (object) ['name' => 'Chamorro', 'code' => 'ch'],
            (object) ['name' => 'Chechen', 'code' => 'ce'],
            (object) ['name' => 'Chichewa, Chewa, Nyanja', 'code' => 'ny'],
            (object) ['name' => 'Chinese', 'code' => 'zh'],
            (object) ['name' => 'Chinese (Simplified)', 'code' => 'zh-Hans'],
            (object) ['name' => 'Chinese (Traditional)', 'code' => 'zh-Hant'],
            (object) ['name' => 'Chuvash', 'code' => 'cv'],
            (object) ['name' => 'Cornish', 'code' => 'kw'],
            (object) ['name' => 'Corsican', 'code' => 'co'],
            (object) ['name' => 'Cree', 'code' => 'cr'],
            (object) ['name' => 'Croatian', 'code' => 'hr'],
            (object) ['name' => 'Czech', 'code' => 'cs'],
            (object) ['name' => 'Danish', 'code' => 'da'],
            (object) ['name' => 'Divehi, Dhivehi, Maldivian', 'code' => 'dv'],
            (object) ['name' => 'Dutch', 'code' => 'nl'],
            (object) ['name' => 'Dzongkha', 'code' => 'dz'],
            (object) ['name' => 'English', 'code' => 'en'],
            (object) ['name' => 'Esperanto', 'code' => 'eo'],
            (object) ['name' => 'Estonian', 'code' => 'et'],
            (object) ['name' => 'Ewe', 'code' => 'ee'],
            (object) ['name' => 'Faroese', 'code' => 'fo'],
            (object) ['name' => 'Fijian', 'code' => 'fj'],
            (object) ['name' => 'Finnish', 'code' => 'fi'],
            (object) ['name' => 'French', 'code' => 'fr'],
            (object) ['name' => 'Fula, Fulah, Pulaar, Pular', 'code' => 'ff'],
            (object) ['name' => 'Galician', 'code' => 'gl'],
            (object) ['name' => 'Gaelic (Scottish)', 'code' => 'gd'],
            (object) ['name' => 'Gaelic (Manx)', 'code' => 'gv'],
            (object) ['name' => 'Georgian', 'code' => 'ka'],
            (object) ['name' => 'German', 'code' => 'de'],
            (object) ['name' => 'Greek', 'code' => 'el'],
            (object) ['name' => 'Greenlandic', 'code' => 'kl'],
            (object) ['name' => 'Guarani', 'code' => 'gn'],
            (object) ['name' => 'Gujarati', 'code' => 'gu'],
            (object) ['name' => 'Haitian Creole', 'code' => 'ht'],
            (object) ['name' => 'Hausa', 'code' => 'ha'],
            (object) ['name' => 'Hebrew', 'code' => 'he'],
            (object) ['name' => 'Herero', 'code' => 'hz'],
            (object) ['name' => 'Hindi', 'code' => 'hi'],
            (object) ['name' => 'Hiri Motu', 'code' => 'ho'],
            (object) ['name' => 'Hungarian', 'code' => 'hu'],
            (object) ['name' => 'Icelandic', 'code' => 'is'],
            (object) ['name' => 'Ido', 'code' => 'io'],
            (object) ['name' => 'Igbo', 'code' => 'ig'],
            (object) ['name' => 'Indonesian', 'code' => 'id'],
            (object) ['name' => 'Interlingua', 'code' => 'ia'],
            (object) ['name' => 'Interlingue', 'code' => 'ie'],
            (object) ['name' => 'Inuktitut', 'code' => 'iu'],
            (object) ['name' => 'Inupiak', 'code' => 'ik'],
            (object) ['name' => 'Irish', 'code' => 'ga'],
            (object) ['name' => 'Italian', 'code' => 'it'],
            (object) ['name' => 'Japanese', 'code' => 'ja'],
            (object) ['name' => 'Javanese', 'code' => 'jv'],
            (object) ['name' => 'Kalaallisut, Greenlandic', 'code' => 'kl'],
            (object) ['name' => 'Kannada', 'code' => 'kn'],
            (object) ['name' => 'Kanuri', 'code' => 'kr'],
            (object) ['name' => 'Kashmiri', 'code' => 'ks'],
            (object) ['name' => 'Kazakh', 'code' => 'kk'],
            (object) ['name' => 'Khmer', 'code' => 'km'],
            (object) ['name' => 'Kikuyu', 'code' => 'ki'],
            (object) ['name' => 'Kinyarwanda (Rwanda)', 'code' => 'rw'],
            (object) ['name' => 'Kirundi', 'code' => 'rn'],
            (object) ['name' => 'Kyrgyz', 'code' => 'ky'],
            (object) ['name' => 'Komi', 'code' => 'kv'],
            (object) ['name' => 'Kongo', 'code' => 'kg'],
            (object) ['name' => 'Korean', 'code' => 'ko'],
            (object) ['name' => 'Kurdish', 'code' => 'ku'],
            (object) ['name' => 'Kwanyama', 'code' => 'kj'],
            (object) ['name' => 'Lao', 'code' => 'lo'],
            (object) ['name' => 'Latin', 'code' => 'la'],
            (object) ['name' => 'Latvian (Lettish)', 'code' => 'lv'],
            (object) ['name' => 'Limburgish ( Limburger)', 'code' => 'li'],
            (object) ['name' => 'Lingala', 'code' => 'ln'],
            (object) ['name' => 'Lithuanian', 'code' => 'lt'],
            (object) ['name' => 'Luga-Katanga', 'code' => 'lu'],
            (object) ['name' => 'Luganda, Ganda', 'code' => 'lg'],
            (object) ['name' => 'Luxembourgish', 'code' => 'lb'],
            (object) ['name' => 'Macedonian', 'code' => 'mk'],
            (object) ['name' => 'Malagasy', 'code' => 'mg'],
            (object) ['name' => 'Malay', 'code' => 'ms'],
            (object) ['name' => 'Malayalam', 'code' => 'ml'],
            (object) ['name' => 'Maltese', 'code' => 'mt'],
            (object) ['name' => 'Maori', 'code' => 'mi'],
            (object) ['name' => 'Marathi', 'code' => 'mr'],
            (object) ['name' => 'Marshallese', 'code' => 'mh'],
            (object) ['name' => 'Moldavian', 'code' => 'mo'],
            (object) ['name' => 'Mongolian', 'code' => 'mn'],
            (object) ['name' => 'Nauru', 'code' => 'na'],
            (object) ['name' => 'Navajo', 'code' => 'nv'],
            (object) ['name' => 'Ndonga', 'code' => 'ng'],
            (object) ['name' => 'Northern Ndebele', 'code' => 'nd'],
            (object) ['name' => 'Nepali', 'code' => 'ne'],
            (object) ['name' => 'Norwegian', 'code' => 'no'],
            (object) ['name' => 'Norwegian bokmål', 'code' => 'nb'],
            (object) ['name' => 'Norwegian nynorsk', 'code' => 'nn'],
            (object) ['name' => 'Nuosu', 'code' => 'ii'],
            (object) ['name' => 'Occitan', 'code' => 'oc'],
            (object) ['name' => 'Ojibwe', 'code' => 'oj'],
            (object) ['name' => 'Old Church Slavonic, Old Bulgarian', 'code' => 'cu'],
            (object) ['name' => 'Oriya', 'code' => 'or'],
            (object) ['name' => 'Oromo (Afaan Oromo)', 'code' => 'om'],
            (object) ['name' => 'Ossetian', 'code' => 'os'],
            (object) ['name' => 'Pāli', 'code' => 'pi'],
            (object) ['name' => 'Pashto, Pushto', 'code' => 'ps'],
            (object) ['name' => 'Persian (Farsi)', 'code' => 'fa'],
            (object) ['name' => 'Polish', 'code' => 'pl'],
            (object) ['name' => 'Portuguese', 'code' => 'pt'],
            (object) ['name' => 'Punjabi (Eastern)', 'code' => 'pa'],
            (object) ['name' => 'Quechua', 'code' => 'qu'],
            (object) ['name' => 'Romansh', 'code' => 'rm'],
            (object) ['name' => 'Romanian', 'code' => 'ro'],
            (object) ['name' => 'Russian', 'code' => 'ru'],
            (object) ['name' => 'Sami', 'code' => 'se'],
            (object) ['name' => 'Samoan', 'code' => 'sm'],
            (object) ['name' => 'Sango', 'code' => 'sg'],
            (object) ['name' => 'Sanskrit', 'code' => 'sa'],
            (object) ['name' => 'Serbian', 'code' => 'sr'],
            (object) ['name' => 'Serbo-Croatian', 'code' => 'sh'],
            (object) ['name' => 'Sesotho', 'code' => 'st'],
            (object) ['name' => 'Setswana', 'code' => 'tn'],
            (object) ['name' => 'Shona', 'code' => 'sn'],
            (object) ['name' => 'Sichuan Yi', 'code' => 'ii'],
            (object) ['name' => 'Sindhi', 'code' => 'sd'],
            (object) ['name' => 'Sinhalese', 'code' => 'si'],
            (object) ['name' => 'Siswati', 'code' => 'ss'],
            (object) ['name' => 'Slovak', 'code' => 'sk'],
            (object) ['name' => 'Slovenian', 'code' => 'sl'],
            (object) ['name' => 'Somali', 'code' => 'so'],
            (object) ['name' => 'Southern Ndebele', 'code' => 'nr'],
            (object) ['name' => 'Spanish', 'code' => 'es'],
            (object) ['name' => 'Sundanese', 'code' => 'su'],
            (object) ['name' => 'Swahili (Kiswahili)', 'code' => 'sw'],
            (object) ['name' => 'Swati', 'code' => 'ss'],
            (object) ['name' => 'Swedish', 'code' => 'sv'],
            (object) ['name' => 'Tagalog', 'code' => 'tl'],
            (object) ['name' => 'Tahitian', 'code' => 'ty'],
            (object) ['name' => 'Tajik', 'code' => 'tg'],
            (object) ['name' => 'Tamil', 'code' => 'ta'],
            (object) ['name' => 'Tatar', 'code' => 'tt'],
            (object) ['name' => 'Telugu', 'code' => 'te'],
            (object) ['name' => 'Thai', 'code' => 'th'],
            (object) ['name' => 'Tibetan', 'code' => 'bo'],
            (object) ['name' => 'Tigrinya', 'code' => 'ti'],
            (object) ['name' => 'Tonga', 'code' => 'to'],
            (object) ['name' => 'Tsonga', 'code' => 'ts'],
            (object) ['name' => 'Turkish', 'code' => 'tr'],
            (object) ['name' => 'Turkmen', 'code' => 'tk'],
            (object) ['name' => 'Twi', 'code' => 'tw'],
            (object) ['name' => 'Uyghur', 'code' => 'ug'],
            (object) ['name' => 'Ukrainian', 'code' => 'uk'],
            (object) ['name' => 'Urdu', 'code' => 'ur'],
            (object) ['name' => 'Uzbek', 'code' => 'uz'],
            (object) ['name' => 'Venda', 'code' => 've'],
            (object) ['name' => 'Vietnamese', 'code' => 'vi'],
            (object) ['name' => 'Volapük', 'code' => 'vo'],
            (object) ['name' => 'Wallon', 'code' => 'wa'],
            (object) ['name' => 'Welsh', 'code' => 'cy'],
            (object) ['name' => 'Wolof', 'code' => 'wo'],
            (object) ['name' => 'Western Frisian', 'code' => 'fy'],
            (object) ['name' => 'Xhosa', 'code' => 'xh'],
            (object) ['name' => 'Yiddish', 'code' => 'yi, ji'],
            (object) ['name' => 'Yoruba', 'code' => 'yo'],
            (object) ['name' => 'Zhuang, Chuang', 'code' => 'za'],
            (object) ['name' => 'Zulu', 'code' => 'zu'],
        ];

        return collect($languages);
    }
}
